<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/ConfrontoImmagini.php";
    
    $impostazioni = recuperaImpostazioni($geecomDb);

    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new ConfrontoImmagini($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new ConfrontoImmagini($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING));
            $occorrenza->crea();
            header("Location: ../creaSezione.php?id={$occorrenza->getId()}&status=200");
            break;
        case 'modifica':
            $occorrenza->caricaDatiDalDatabase();
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $occorrenza->modifica();
            header("Location: ../creaSezione.php?id={$occorrenza->getId()}&status=250");
            break;
        case 'modificaImmagine1':
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif","video/mp4");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $occorrenza->cambiaImmagine1($percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'modificaImmagineElementoConPercorso':
            $idElemento = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $occorrenza->setId($idElemento); // necessario mantenere idElemento per compatibilità con il vecchio sistema
            $occorrenza->cambiaImmagine1($percorso);
            echo "ok";
            break;
        case 'modificaImmagine2':
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif","video/mp4");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $occorrenza->cambiaImmagine2($percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'modificaImmagine2ConPercorso':
            $idElemento = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $occorrenza->cambiaImmagine2($percorso);
            echo "ok";
            break;
        case 'elimina':
            $occorrenza->elimina();
            echo "ok";
            break;
        case 'eliminaImmagine1':
            $occorrenza->cambiaImmagine1('');
            echo "ok";
            break;
        case 'eliminaImmagine2':
            $occorrenza->cambiaImmagine2('');
            echo "ok";
            break;
        case 'duplica':
            $occorrenza->caricaDatiDalDatabase();
            $idNuovaForm = $occorrenza->duplica();
            header("Location: ../creaSezione.php?id={$idNuovaForm}&status=260");
            break;
    }